dnl @synopsis ACX_LAPACK([ACTION-IF-FOUND[, ACTION-IF-NOT-FOUND]])
dnl
dnl This macro looks for a library that implements the LAPACK
dnl linear-algebra interface (see http://www.netlib.org/lapack/).
dnl On success, it sets the LAPACK_LIBS output variable to
dnl hold the requisite library linkages.
dnl
dnl To link with LAPACK, you should link with:
dnl 	$LAPACK_LIBS $BLAS_LIBS $LIBS $FLIBS
dnl in that order.  BLAS_LIBS is the output variable of the ACX_BLAS
dnl macro, called automatically.  FLIBS is the output variable of the
dnl AC_F77_LIBRARY_LDFLAGS macro (called if necessary by ACX_BLAS),
dnl and is sometimes necessary in order to link with F77 libraries.
dnl Users will also need to use AC_F77_DUMMY_MAIN (see the autoconf
dnl manual), for the same reason.
dnl
dnl The user may also use --with-lapack=<lib> in order to use some
dnl specific LAPACK library <lib>.  In order to link successfully,
dnl however, be aware that you will probably need to use the same
dnl Fortran compiler (which can be set via the F77 env. var.) as
dnl was used to compile the LAPACK and BLAS libraries.
dnl
dnl ACTION-IF-FOUND is a list of shell commands to run if a LAPACK
dnl library is found, and ACTION-IF-NOT-FOUND is a list of commands
dnl to run it if it is not found.  If ACTION-IF-FOUND is not specified,
dnl the default action will define HAVE_LAPACK.
dnl
dnl @version $Id: acx_lapack.m4,v 1.3 2005/05/24 13:24:29 vierinen Exp $
dnl @author Steven G. Johnson <stevenj@alum.mit.edu>

AC_DEFUN([ACX_LAPACK], [
AC_REQUIRE([ACX_BLAS])
acx_lapack_ok=no

AC_ARG_WITH(lapack,
	[AC_HELP_STRING([--with-lapack=<lib>], [use LAPACK library <lib>])])
case $with_lapack in
	yes | "") ;;
	no) acx_lapack_ok=disable ;;
	-* | */* | *.a | *.so | *.so.* | *.o) LAPACK_LIBS="$with_lapack" ;;
	*) LAPACK_LIBS="-l$with_lapack" ;;
esac

# Get fortran linker name of LAPACK function to check for.
AC_FC_FUNC(cheev)

# We cannot use LAPACK if BLAS is not found
if test "x$acx_blas_ok" != xyes; then
	acx_lapack_ok=noblas
fi

# First, check LAPACK_LIBS environment variable
if test "x$LAPACK_LIBS" != x; then
	save_LIBS="$LIBS"; LIBS="$LAPACK_LIBS $BLAS_LIBS $LIBS $FLIBS $FCLIBS"
	AC_MSG_CHECKING([for $cheev in $LAPACK_LIBS])

	if test "$acx_cv_c_compiler_ms" = "yes"; then
		# windose shite	
		save_CFLAGS="$CFLAGS"
		CFLAGS="$CFLAGS -Gz"
		AC_LINK_IFELSE(
		[int main ()
		 {
		   $cheev(1,2,3,4,5,6,7,8,9,10,11,12);
		   return 0;
		 }
		],
		[
	      		acx_lapack_ok=yes
		],
		[
	 	        LAPACK_LIBS=""	
		])
		CFLAGS="$save_CFLAGS"
	else
		AC_TRY_LINK_FUNC($cheev, [acx_lapack_ok=yes], [LAPACK_LIBS=""])
	fi

	AC_MSG_RESULT($acx_lapack_ok)
	LIBS="$save_LIBS"
	if test acx_lapack_ok = no; then
		LAPACK_LIBS=""
	fi
fi

# LAPACK linked to by default?  (is sometimes included with BLAS)
if test $acx_lapack_ok = no; then
	save_LIBS="$LIBS"; LIBS="$LIBS $BLAS_LIBS $FLIBS $FCLIBS"

	if test "$acx_cv_c_compiler_ms" = "yes"; then
		# windose shite	
		save_CFLAGS="$CFLAGS"
		CFLAGS="$CFLAGS -Gz"
		AC_LINK_IFELSE(
		[int main ()
		 {
		   $cheev(1,2,3,4,5,6,7,8,9,10,11,12);
		   return 0;
		 }
		],
		[
	      		acx_lapack_ok=yes
		],
		[
	 	        LAPACK_LIBS=""	
		])
		CFLAGS="$save_CFLAGS"
	else
		AC_CHECK_FUNC($cheev, [acx_lapack_ok=yes])
	fi

	LIBS="$save_LIBS"
fi

# Generic LAPACK library?
for lapack in lapack lapack_rs6k lapack_64; do
	if test $acx_lapack_ok = no; then
		save_LIBS="$LIBS"; LIBS="$BLAS_LIBS $LIBS"
		AC_CHECK_LIB($lapack, $cheev,
		    [acx_lapack_ok=yes; LAPACK_LIBS="-l$lapack"], [], [$FLIBS $FCLIBS])
		LIBS="$save_LIBS"
	fi
done

AC_SUBST(LAPACK_LIBS)

# Finally, execute ACTION-IF-FOUND/ACTION-IF-NOT-FOUND:
if test x"$acx_lapack_ok" = xyes; then
        ifelse([$1],,AC_DEFINE(HAVE_LAPACK,1,[Define if you have LAPACK library.]),[$1])
        :
else
        acx_lapack_ok=no
        $2
fi
])dnl ACX_LAPACK
