//
// File: PanelSaisieParametresSignature.cc
// Created by: Éric Laly <elaly@free.fr>
// Created on: Tue Oct 17 11:22:30 2006
//

#include "PanelSaisieParametresSignature.h"
#include <wx/colordlg.h>


PanelSaisieParametresSignature::PanelSaisieParametresSignature(wxWindow* parent,int id,wxColor couleurbouton):wxPanel(parent, id)
{


    panel_saisie_pourcentage_fonte_signature = new PanelSaisieSlider(this,-1,wxT("Pourcentage: "),0.1,20,2,1);

    button_couleur_signature= new wxButton(this, -1, wxT("-             -"), wxDefaultPosition, wxDefaultSize, wxBU_EXACTFIT);
    button_couleur_signature->SetBackgroundColour(couleurbouton);
    button_couleur_signature->SetForegroundColour(couleurbouton);
    checkbox_couleur_auto = new wxCheckBox(this, -1, wxT("Couleur Auto."));
    sizer_couleur_signature_staticbox= new wxStaticBox(this, -1, wxT("Couleur"));
    wxStaticBoxSizer* sizer_couleur_signature= new wxStaticBoxSizer(sizer_couleur_signature_staticbox, wxHORIZONTAL);
    sizer_couleur_signature->Add(button_couleur_signature, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer_couleur_signature->Add(checkbox_couleur_auto, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);

    wxBoxSizer* sizer_pourcentage_couleur_signature = new wxBoxSizer(wxHORIZONTAL);
    sizer_pourcentage_couleur_signature->Add(panel_saisie_pourcentage_fonte_signature, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer_pourcentage_couleur_signature->Add(sizer_couleur_signature, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    
    
    const wxString radio_box_position_signature_choices[] = {
        wxT("Bas-Droite"),
        wxT("Haut-Droite")
    };
    radio_box_position_signature = new wxRadioBox(this, -1, wxT("Position"), wxDefaultPosition, wxDefaultSize, 2, radio_box_position_signature_choices, 0, wxRA_SPECIFY_COLS);
    radio_box_position_signature->SetSelection(0);

    label_texte_signature = new wxStaticText(this, -1, wxT("Texte de la signature: "));
    text_ctrl_texte_signature = new wxTextCtrl(this, -1, wxT(""));
    wxBoxSizer* sizer_texte_signature = new wxBoxSizer(wxHORIZONTAL);
    sizer_texte_signature->Add(label_texte_signature, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer_texte_signature->Add(text_ctrl_texte_signature, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);

    sizer_parametres_signature= new wxBoxSizer( wxVERTICAL);
    sizer_parametres_signature->Add(sizer_pourcentage_couleur_signature, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer_parametres_signature->Add(radio_box_position_signature, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer_parametres_signature->Add(sizer_texte_signature, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 2);

    SetSizer(sizer_parametres_signature);
    
    checkbox_couleur_auto->Hide(); //non implémenté pour l'instant.
	// on connecte les événements
   	Connect(button_couleur_signature->GetId( ), wxEVT_COMMAND_BUTTON_CLICKED, 
											(wxObjectEventFunction) &PanelSaisieParametresSignature::on_click_button_couleur_signature);

}

PanelSaisieParametresSignature::~PanelSaisieParametresSignature()
{
	// TODO: put destructor code here
}

void PanelSaisieParametresSignature::on_click_button_couleur_signature(wxCommandEvent& event)
{
	wxColourDialog dialog(this);
	if (dialog.ShowModal()==wxID_OK)
	{
		wxColourData retData=dialog.GetColourData();
		wxColour col=retData.GetColour();
		button_couleur_signature->SetBackgroundColour(col);
		button_couleur_signature->SetForegroundColour(col);
	}	
}	

double PanelSaisieParametresSignature::GetPourcentage()
{
    return panel_saisie_pourcentage_fonte_signature->GetValeurReelle();
}    

wxColor PanelSaisieParametresSignature::GetCouleur()
{
    return button_couleur_signature->GetBackgroundColour();
}

wxString PanelSaisieParametresSignature::GetPosition()
{
    return radio_box_position_signature->GetStringSelection();
}

wxString PanelSaisieParametresSignature::GetSignature()
{
    return text_ctrl_texte_signature->GetValue();
}
