/*
 * Copyright (c) 2012, 2015, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.hi;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_hi extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "\u092e\u0949\u0938\u094d\u0915\u094b \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "MST",
               "\u092e\u0949\u0938\u094d\u0915\u094b \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "MST",
               "\u092e\u0949\u0938\u094d\u0915\u094b \u0938\u092e\u092f",
               "MT",
            };
        final String[] Omsk = new String[] {
               "\u0913\u092e\u094d\u0938\u094d\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "OST",
               "\u0913\u092e\u094d\u0938\u094d\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "OST",
               "\u0913\u092e\u094d\u0938\u094d\u0915 \u0938\u092e\u092f",
               "OT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u0939\u0935\u093e\u0908 \u090f\u0932\u094d\u092f\u0941\u0936\u093f\u092f\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "HAST",
               "\u0939\u0935\u093e\u0908 \u090f\u0932\u094d\u092f\u0941\u0936\u093f\u092f\u0928 \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "HADT",
               "\u0939\u0935\u093e\u0908 \u090f\u0932\u094d\u092f\u0941\u0936\u093f\u092f\u0928 \u0938\u092e\u092f",
               "HAT",
            };
        final String[] Sakhalin = new String[] {
               "\u0938\u0916\u093c\u093e\u0932\u093f\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "SST",
               "\u0938\u0916\u093c\u093e\u0932\u093f\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "SST",
               "\u0938\u0916\u093c\u093e\u0932\u093f\u0928 \u0938\u092e\u092f",
               "ST",
            };
        final String[] Yakutsk = new String[] {
               "\u092f\u093e\u0915\u0941\u0924\u094d\u0938\u094d\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "YST",
               "\u092f\u093e\u0915\u0941\u0924\u094d\u0938\u094d\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "YST",
               "\u092f\u093e\u0915\u0941\u0924\u094d\u0938\u094d\u0915 \u0938\u092e\u092f",
               "YT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u092a\u0942\u0930\u094d\u0935 \u0915\u091c\u093c\u093e\u0915\u093c\u093f\u0938\u094d\u0924\u093e\u0928 \u0938\u092e\u092f",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Vladivostok = new String[] {
               "\u0935\u094d\u0932\u093e\u0926\u093f\u0935\u094b\u0938\u094d\u0924\u094b\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "VST",
               "\u0935\u094d\u0932\u093e\u0926\u093f\u0935\u094b\u0938\u094d\u0924\u094b\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "VST",
               "\u0935\u094d\u0932\u093e\u0926\u093f\u0935\u094b\u0938\u094d\u0924\u094b\u0915 \u0938\u092e\u092f",
               "VT",
            };
        final String[] Brasilia = new String[] {
               "\u092c\u094d\u0930\u093e\u091c\u0940\u0932\u093f\u092f\u093e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "BST",
               "\u092c\u094d\u0930\u093e\u091c\u0940\u0932\u093f\u092f\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "BST",
               "\u092c\u094d\u0930\u093e\u091c\u0940\u0932\u093f\u092f\u093e \u0938\u092e\u092f",
               "BT",
            };
        final String[] Hovd = new String[] {
               "\u0939\u0949\u0921 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "HST",
               "\u0939\u0949\u0921 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "HST",
               "\u0939\u0949\u0921 \u0938\u092e\u092f",
               "HT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u0907\u0902\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e\u0908 \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0938\u092e\u092f",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Amazon = new String[] {
               "\u0906\u092e\u0947\u091c\u093c\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "AST",
               "\u0906\u092e\u0947\u091c\u093c\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "AST",
               "\u0906\u092e\u0947\u091c\u093c\u0928 \u0938\u092e\u092f",
               "AT",
            };
        final String[] Mongolia = new String[] {
               "\u0905\u0932\u0928 \u092c\u091f\u094b\u0930 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "UBST",
               "\u0905\u0932\u0928 \u092c\u091f\u094b\u0930 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "UBST",
               "\u0905\u0932\u0928 \u092c\u091f\u094b\u0930 \u0938\u092e\u092f",
               "UBT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u0907\u0902\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e\u0908 \u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u0938\u092e\u092f",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] America_Pacific = new String[] {
               "\u092a\u094d\u0930\u0936\u093e\u0902\u0924 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "PST",
               "\u092a\u094d\u0930\u0936\u093e\u0902\u0924 \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "PDT",
               "\u092a\u094d\u0930\u0936\u093e\u0902\u0924 \u0938\u092e\u092f",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u0940\u0928\u093e \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "WAST",
               "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u0940\u0928\u093e \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "WAST",
               "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u0940\u0928\u093e \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0938\u092e\u092f",
               "WAT",
            };
        final String[] Newfoundland = new String[] {
               "\u0928\u094d\u092f\u0942\u092b\u093c\u093e\u0909\u0902\u0921\u0932\u0948\u0902\u0921 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "NST",
               "\u0928\u094d\u092f\u0942\u092b\u093c\u093e\u0909\u0902\u0921\u0932\u0948\u0902\u0921 \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "NDT",
               "\u0928\u094d\u092f\u0942\u092b\u093c\u093e\u0909\u0902\u0921\u0932\u0948\u0902\u0921 \u0938\u092e\u092f",
               "NT",
            };
        final String[] Volgograd = new String[] {
               "\u0935\u094b\u0932\u094d\u0917\u094b\u0917\u094d\u0930\u093e\u0921 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "VST",
               "\u0935\u094b\u0932\u094d\u0917\u094b\u0917\u094d\u0930\u093e\u0921 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "VST",
               "\u0935\u094b\u0932\u094d\u0917\u094b\u0917\u094d\u0930\u093e\u0921 \u0938\u092e\u092f",
               "VT",
            };
        final String[] America_Central = new String[] {
               "\u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "CST",
               "\u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "CDT",
               "\u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u0938\u092e\u092f",
               "CT",
            };
        final String[] Argentina = new String[] {
               "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u0940\u0928\u093e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "AST",
               "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u0940\u0928\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "AST",
               "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u0940\u0928\u093e \u0938\u092e\u092f",
               "AT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u092f\u0947\u0915\u093e\u0924\u0947\u0930\u093f\u0928\u092c\u0930\u094d\u0917 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "YST",
               "\u092f\u0947\u0915\u093e\u0924\u0947\u0930\u093f\u0928\u092c\u0930\u094d\u0917 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "YST",
               "\u092f\u0947\u0915\u093e\u0924\u0947\u0930\u093f\u0928\u092c\u0930\u094d\u0917 \u0938\u092e\u092f",
               "YT",
            };
        final String[] Lord_Howe = new String[] {
               "\u0932\u0949\u0930\u094d\u0921 \u0939\u0949\u0935\u0947 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "LHST",
               "\u0932\u0949\u0930\u094d\u0921 \u0939\u0949\u0935\u0947 \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "LHDT",
               "\u0932\u0949\u0930\u094d\u0921 \u0939\u0949\u0935\u0947 \u0938\u092e\u092f",
               "LHT",
            };
        final String[] Macquarie = new String[] {
               "\u092e\u0948\u0915\u094d\u0935\u0930\u0940 \u0938\u092e\u092f",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u0911\u0938\u094d\u200d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u092a\u0942\u0930\u094d\u0935\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "AEST",
               "\u0911\u0938\u094d\u200d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u092a\u0942\u0930\u094d\u0935\u0940 \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "AEDT",
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u0938\u092e\u092f",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "\u0907\u0930\u094d\u0915\u0941\u0924\u094d\u0938\u094d\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "IST",
               "\u0907\u0930\u094d\u0915\u0941\u0924\u094d\u0938\u094d\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "IST",
               "\u0907\u0930\u094d\u0915\u0941\u0924\u094d\u0938\u094d\u0915 \u0938\u092e\u092f",
               "IT",
            };
        final String[] Choibalsan = new String[] {
               "\u091a\u094c\u0907\u092c\u093e\u0932\u094d\u0938\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "CST",
               "\u091a\u094c\u0907\u092c\u093e\u0932\u094d\u0938\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "CST",
               "\u091a\u094c\u0907\u092c\u093e\u0932\u094d\u0938\u0928 \u0938\u092e\u092f",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "EST",
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "EDT",
               "\u092a\u0942\u0930\u094d\u0935\u0940 \u0938\u092e\u092f",
               "ET",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u092a\u0936\u094d\u091a\u093f\u092e \u0915\u091c\u093c\u093e\u0915\u093c\u093f\u0938\u094d\u0924\u093e\u0928 \u0938\u092e\u092f",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0911\u0938\u094d\u200d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "ACWST",
               "\u0911\u0938\u094d\u200d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "ACWDT",
               "\u0911\u0938\u094d\u200d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0938\u092e\u092f",
               "ACWT",
            };
        final String[] Australia_Western = new String[] {
               "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "AWST",
               "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "AWDT",
               "\u092a\u0936\u094d\u091a\u093f\u092e\u0940 \u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u0938\u092e\u092f",
               "WAT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u0915\u094d\u0930\u093e\u0938\u094d\u0928\u094b\u092f\u093e\u0930\u094d\u0938\u094d\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "KST",
               "\u0915\u094d\u0930\u093e\u0938\u094d\u0928\u094b\u092f\u093e\u0930\u094d\u0938\u094d\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "KST",
               "\u0915\u094d\u0930\u093e\u0938\u094d\u0928\u094b\u092f\u093e\u0930\u094d\u0938\u094d\u0915 \u0938\u092e\u092f",
               "KT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u0907\u0902\u0921\u094b\u0928\u0947\u0936\u093f\u092f\u093e\u0908 \u092a\u0942\u0930\u094d\u0935\u0940 \u0938\u092e\u092f",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Noronha = new String[] {
               "\u092b\u093c\u0930\u094d\u0928\u093e\u0930\u094d\u0921\u094b \u0921\u0947 \u0928\u094b\u0930\u094b\u0928\u094d\u0939\u093e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "FNST",
               "\u092b\u093c\u0930\u094d\u0928\u093e\u0930\u094d\u0921\u094b \u0921\u0947 \u0928\u094b\u0930\u094b\u0928\u094d\u0939\u093e \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "FNST",
               "\u092b\u093c\u0930\u094d\u0928\u093e\u0930\u094d\u0921\u094b \u0921\u0947 \u0928\u094b\u0930\u094b\u0928\u094d\u0939\u093e \u0938\u092e\u0939",
               "FNT",
            };
        final String[] Novosibirsk = new String[] {
               "\u0928\u094b\u0935\u094b\u0938\u093f\u092c\u093f\u0930\u094d\u0938\u094d\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "NST",
               "\u0928\u094b\u0935\u094b\u0938\u093f\u092c\u093f\u0930\u094d\u0938\u094d\u0915 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "NST",
               "\u0928\u094b\u0935\u094b\u0938\u093f\u092c\u093f\u0930\u094d\u0938\u094d\u0915 \u0938\u092e\u092f",
               "NT",
            };
        final String[] America_Mountain = new String[] {
               "\u092e\u093e\u0909\u0902\u091f\u0947\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "MST",
               "\u092e\u093e\u0909\u0902\u091f\u0947\u0928 \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "MDT",
               "\u092e\u093e\u0909\u0902\u091f\u0947\u0928 \u0938\u092e\u092f",
               "MT",
            };
        final String[] India = new String[] {
               "\u092d\u093e\u0930\u0924\u0940\u092f \u0938\u092e\u092f",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Alaska = new String[] {
               "\u0905\u0932\u093e\u0938\u094d\u200d\u0915\u093e \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "AKST",
               "\u0905\u0932\u093e\u0938\u094d\u200d\u0915\u093e \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "AKDT",
               "\u0905\u0932\u093e\u0938\u094d\u0915\u093e \u0938\u092e\u092f",
               "AKT",
            };
        final String[] Australia_Central = new String[] {
               "\u0911\u0938\u094d\u200d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "ACST",
               "\u0911\u0938\u094d\u200d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "ACDT",
               "\u0915\u0947\u0902\u0926\u094d\u0930\u0940\u092f \u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0908 \u0938\u092e\u092f",
               "CAT",
            };
        final String[] Atlantic = new String[] {
               "\u0905\u091f\u0932\u093e\u0902\u091f\u093f\u0915 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "AST",
               "\u0905\u091f\u0932\u093e\u0902\u091f\u093f\u0915 \u0926\u093f\u0935\u093e\u0935\u0932\u094b\u0915 \u0938\u092e\u092f",
               "ADT",
               "\u0905\u091f\u0932\u093e\u0902\u091f\u093f\u0915 \u0938\u092e\u092f",
               "AT",
            };
        final String[] Magadan = new String[] {
               "\u092e\u0948\u0917\u093e\u0921\u0928 \u092e\u093e\u0928\u0915 \u0938\u092e\u092f",
               "MST",
               "\u092e\u0948\u0917\u093e\u0921\u0928 \u0917\u094d\u0930\u0940\u0937\u094d\u092e\u0915\u093e\u0932\u0940\u0928 \u0938\u092e\u092f",
               "MST",
               "\u092e\u0948\u0917\u093e\u0921\u0928 \u0938\u092e\u092f",
               "MT",
            };
        final Object[][] data = new Object[][] {
            { "Europe/Samara", Moscow },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Yakutat", Alaska },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "America/St_Vincent", Atlantic },
            { "America/Port-au-Prince", America_Eastern },
            { "Asia/Colombo", India },
            { "America/New_York", America_Eastern },
            { "Europe/Volgograd", Volgograd },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "America/Resolute", America_Central },
            { "America/Winnipeg", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Anguilla", Atlantic },
            { "America/Regina", America_Central },
            { "Asia/Vladivostok", Vladivostok },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/North_Dakota/Center", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Thule", Atlantic },
            { "America/Bahia_Banderas", America_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Chihuahua", America_Mountain },
            { "America/Yellowknife", America_Mountain },
            { "Antarctica/Casey", Australia_Western },
            { "PST8PDT", America_Pacific },
            { "America/Cayman", America_Eastern },
            { "America/St_Johns", Newfoundland },
            { "Asia/Omsk", Omsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Curacao", Atlantic },
            { "Asia/Choibalsan", Choibalsan },
            { "America/Indiana/Winamac", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Toronto", America_Eastern },
            { "America/Montserrat", Atlantic },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "America/Porto_Velho", Amazon },
            { "America/Costa_Rica", America_Central },
            { "America/Indianapolis", America_Eastern },
            { "America/Fortaleza", Brasilia },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Mexico_City", America_Central },
            { "America/El_Salvador", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "America/Halifax", Atlantic },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Managua", America_Central },
            { "EST5EDT", America_Eastern },
            { "America/Moncton", Atlantic },
            { "America/Nome", Alaska },
            { "America/Maceio", Brasilia },
            { "America/Rio_Branco", Amazon },
            { "America/Belize", America_Central },
            { "America/Cuiaba", Amazon },
            { "America/Vancouver", America_Pacific },
            { "America/Rankin_Inlet", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Guatemala", America_Central },
            { "America/Montreal", America_Eastern },
            { "America/Glace_Bay", Atlantic },
            { "America/Cambridge_Bay", America_Mountain },
            { "Australia/Brisbane", Australia_Eastern },
            { "America/Ojinaga", America_Mountain },
            { "America/Barbados", Atlantic },
            { "America/Grenada", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Metlakatla", America_Pacific },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "America/Jamaica", America_Eastern },
            { "America/Manaus", Amazon },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Phoenix", America_Mountain },
            { "Asia/Makassar", Indonesia_Central },
            { "Australia/Currie", Australia_Eastern },
            { "America/Anchorage", Alaska },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Cancun", America_Central },
            { "America/Jujuy", Argentina },
            { "America/Buenos_Aires", Argentina },
            { "Asia/Calcutta", India },
            { "America/Dawson_Creek", America_Mountain },
            { "Asia/Anadyr", Magadan },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Puerto_Rico", Atlantic },
            { "America/Denver", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Nassau", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Campo_Grande", Amazon },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Hermosillo", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/Boise", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Chicago", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/Menominee", America_Central },
            { "America/Boa_Vista", Amazon },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "America/Juneau", Alaska },
            { "America/Araguaina", Brasilia },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/St_Lucia", Atlantic },
            { "Asia/Yakutsk", Yakutsk },
            { "America/Panama", America_Eastern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/St_Thomas", Atlantic },
            { "Australia/Lindeman", Australia_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "America/Shiprock", America_Mountain },
            { "Australia/Perth", Australia_Western },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "America/Edmonton", America_Mountain },
            { "America/Santo_Domingo", Atlantic },
            { "America/Los_Angeles", America_Pacific },
            { "America/Creston", America_Mountain },
            { "America/Goose_Bay", Atlantic },
            { "America/Noronha", Noronha },
            { "America/Nipigon", America_Eastern },
            { "America/Dominica", Atlantic },
            { "Antarctica/Macquarie", Macquarie },
            { "Australia/Darwin", Australia_Central },
            { "MST7MDT", America_Mountain },
            { "Australia/Adelaide", Australia_Central },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/St_Barthelemy", Atlantic },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/Eirunepe", Amazon },
            { "America/Monterrey", America_Central },
            { "America/Sitka", Alaska },
        };
        return data;
    }
}
