#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2008-2009 Alessio Treglia
#
# This file is part of installation-report-generator.
#
# installation-report-generator is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# installation-report-generator is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with installation-report-generator.  If not, see <http://www.gnu.org/licenses/>.

import os
import irgenerator.globals

config = {}
try:
    configurations = open( os.path.join( os.path.expanduser('~'), irgenerator.globals.RCFILE ) ).read()
    for line in configurations.split('\n'):
        if line.startswith('#') or len(line) == 0 :
            continue
        values = line.split('=')
        config[ values[0].strip() ] = values[1].strip()
except IOError:
    pass
