/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jndi.java;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jndi.java.javaRootURLContext;

public class javaURLContextFactory
implements ObjectFactory {
    private static Log log = LogFactory.getLog(javaURLContextFactory.class);

    public Object getObjectInstance(Object url, Name name, Context ctx, Hashtable env) throws Exception {
        if (url == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)">>> new root context requested ");
            }
            return new javaRootURLContext(env);
        }
        if (url instanceof String) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(">>> resolution of url " + url + " requested"));
            }
            javaRootURLContext rootctx = new javaRootURLContext(env);
            return rootctx.lookup((String)url);
        }
        if (url instanceof String[]) {
            if (log.isDebugEnabled()) {
                log.debug((Object)">>> resolution of array of urls requested");
            }
            String[] urls = (String[])url;
            javaRootURLContext rootctx = new javaRootURLContext(env);
            Object object = null;
            NamingException e = null;
            for (int i = 0; i < urls.length && object == null; ++i) {
                try {
                    object = rootctx.lookup(urls[i]);
                    continue;
                }
                catch (NamingException x) {
                    e = x;
                }
            }
            if (object == null) {
                throw e;
            }
            return object;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)">>> No idea what to do, so return a new root context anyway");
        }
        return new javaRootURLContext(env);
    }
}

