#!/bin/sh
SOURCE=$(dpkg-parsechangelog | sed -ne 's,Source: \(.*\),\1,p')
VERSION=$(dpkg-parsechangelog | sed -ne 's,^Version: \(.*\)-.*,\1,p')
echo $VERSION
UNDERSCOREVERSION=$( echo $VERSION | sed 's/\./_/g')
FILE=$3
TAR=../${SOURCE}_${VERSION}.orig.tar.bz2
DIR=$SOURCE-$VERSION

svn co https://svn.java.net/svn/jtharness~svn/tags/$SOURCE-$UNDERSCOREVERSION/code/ $DIR
tar -jcf  $TAR  --exclude '*.svn*' $DIR
rm -rf $DIR $FILE

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi

exit 0