/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.web.JsonUtil;

@Provider
public class ExceptionHandler
implements ExceptionMapper<Exception> {
    public static final Log LOG = LogFactory.getLog(ExceptionHandler.class);

    public Response toResponse(Exception e) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"GOT EXCEPITION", (Throwable)e);
        }
        Response.Status s = e instanceof SecurityException ? Response.Status.UNAUTHORIZED : (e instanceof FileNotFoundException ? Response.Status.NOT_FOUND : (e instanceof IOException ? Response.Status.FORBIDDEN : (e instanceof UnsupportedOperationException ? Response.Status.BAD_REQUEST : Response.Status.INTERNAL_SERVER_ERROR)));
        String js = JsonUtil.toJsonString(e);
        return Response.status((Response.Status)s).type("application/json").entity((Object)js).build();
    }
}

