//
// Copyright 2023 Ettus Research, A National Instruments Company
//
// SPDX-License-Identifier: LGPL-3.0-or-later
//
// Module: ps_cpld_base_regmap_utils.vh
// Description:
// The constants in this file are autogenerated by XmlParse.

//===============================================================================
// A numerically ordered list of registers and their HDL source files
//===============================================================================

  // SIGNATURE_REGISTER                  : 0x0 (ps_cpld_regs.v)
  // REVISION_REGISTER                   : 0x4 (ps_cpld_regs.v)
  // OLDEST_COMPATIBLE_REVISION_REGISTER : 0x8 (ps_cpld_regs.v)
  // SCRATCH_REGISTER                    : 0xC (ps_cpld_regs.v)
  // GIT_HASH_REGISTER                   : 0x10 (ps_cpld_regs.v)
  // PL_DB_REGISTER                      : 0x20 (ps_cpld_regs.v)
  // DIO_DIRECTION_REGISTER              : 0x30 (ps_cpld_regs.v)
  // SERIAL_NUM_LOW_REG                  : 0x34 (ps_cpld_regs.v)
  // SERIAL_NUM_HIGH_REG                 : 0x38 (ps_cpld_regs.v)
  // CMI_CONTROL_STATUS                  : 0x3C (ps_cpld_regs.v)

//===============================================================================
// RegTypes
//===============================================================================

//===============================================================================
// Register Group DIO_REGS
//===============================================================================

  // DIO_DIRECTION_REGISTER Register (from ps_cpld_regs.v)
  localparam DIO_DIRECTION_REGISTER = 'h30; // Register Offset
  localparam DIO_DIRECTION_REGISTER_SIZE = 32;  // register width in bits
  localparam DIO_DIRECTION_REGISTER_MASK = 32'hFFF0FFF;
  localparam DIO_DIRECTION_A_SIZE = 12;  //DIO_DIRECTION_REGISTER:DIO_DIRECTION_A
  localparam DIO_DIRECTION_A_MSB  = 11;  //DIO_DIRECTION_REGISTER:DIO_DIRECTION_A
  localparam DIO_DIRECTION_A      =  0;  //DIO_DIRECTION_REGISTER:DIO_DIRECTION_A
  localparam DIO_DIRECTION_B_SIZE = 12;  //DIO_DIRECTION_REGISTER:DIO_DIRECTION_B
  localparam DIO_DIRECTION_B_MSB  = 27;  //DIO_DIRECTION_REGISTER:DIO_DIRECTION_B
  localparam DIO_DIRECTION_B      = 16;  //DIO_DIRECTION_REGISTER:DIO_DIRECTION_B

//===============================================================================
// Register Group PS_CMI_REGS
//===============================================================================

  // SERIAL_NUM_LOW_REG Register (from ps_cpld_regs.v)
  localparam SERIAL_NUM_LOW_REG = 'h34; // Register Offset
  localparam SERIAL_NUM_LOW_REG_SIZE = 32;  // register width in bits
  localparam SERIAL_NUM_LOW_REG_MASK = 32'h0;

  // SERIAL_NUM_HIGH_REG Register (from ps_cpld_regs.v)
  localparam SERIAL_NUM_HIGH_REG = 'h38; // Register Offset
  localparam SERIAL_NUM_HIGH_REG_SIZE = 8;  // register width in bits
  localparam SERIAL_NUM_HIGH_REG_MASK = 8'h0;

  // CMI_CONTROL_STATUS Register (from ps_cpld_regs.v)
  localparam CMI_CONTROL_STATUS = 'h3C; // Register Offset
  localparam CMI_CONTROL_STATUS_SIZE = 32;  // register width in bits
  localparam CMI_CONTROL_STATUS_MASK = 32'h80000001;
  localparam CMI_READY_SIZE = 1;  //CMI_CONTROL_STATUS:CMI_READY
  localparam CMI_READY_MSB  = 0;  //CMI_CONTROL_STATUS:CMI_READY
  localparam CMI_READY      = 0;  //CMI_CONTROL_STATUS:CMI_READY
  localparam OTHER_SIDE_DETECTED_SIZE =  1;  //CMI_CONTROL_STATUS:OTHER_SIDE_DETECTED
  localparam OTHER_SIDE_DETECTED_MSB  = 31;  //CMI_CONTROL_STATUS:OTHER_SIDE_DETECTED
  localparam OTHER_SIDE_DETECTED      = 31;  //CMI_CONTROL_STATUS:OTHER_SIDE_DETECTED

//===============================================================================
// Register Group PS_CONTROL_REGS
//===============================================================================

  // PL_DB_REGISTER Register (from ps_cpld_regs.v)
  localparam PL_DB_REGISTER = 'h20; // Register Offset
  localparam PL_DB_REGISTER_SIZE = 32;  // register width in bits
  localparam PL_DB_REGISTER_MASK = 32'h337737;
  localparam DB0_CLOCK_ENABLED_SIZE = 1;  //PL_DB_REGISTER:DB0_CLOCK_ENABLED
  localparam DB0_CLOCK_ENABLED_MSB  = 0;  //PL_DB_REGISTER:DB0_CLOCK_ENABLED
  localparam DB0_CLOCK_ENABLED      = 0;  //PL_DB_REGISTER:DB0_CLOCK_ENABLED
  localparam DB1_CLOCK_ENABLED_SIZE = 1;  //PL_DB_REGISTER:DB1_CLOCK_ENABLED
  localparam DB1_CLOCK_ENABLED_MSB  = 1;  //PL_DB_REGISTER:DB1_CLOCK_ENABLED
  localparam DB1_CLOCK_ENABLED      = 1;  //PL_DB_REGISTER:DB1_CLOCK_ENABLED
  localparam PLL_REF_CLOCK_ENABLED_SIZE = 1;  //PL_DB_REGISTER:PLL_REF_CLOCK_ENABLED
  localparam PLL_REF_CLOCK_ENABLED_MSB  = 2;  //PL_DB_REGISTER:PLL_REF_CLOCK_ENABLED
  localparam PLL_REF_CLOCK_ENABLED      = 2;  //PL_DB_REGISTER:PLL_REF_CLOCK_ENABLED
  localparam DB0_RESET_ASSERTED_SIZE = 1;  //PL_DB_REGISTER:DB0_RESET_ASSERTED
  localparam DB0_RESET_ASSERTED_MSB  = 4;  //PL_DB_REGISTER:DB0_RESET_ASSERTED
  localparam DB0_RESET_ASSERTED      = 4;  //PL_DB_REGISTER:DB0_RESET_ASSERTED
  localparam DB1_RESET_ASSERTED_SIZE = 1;  //PL_DB_REGISTER:DB1_RESET_ASSERTED
  localparam DB1_RESET_ASSERTED_MSB  = 5;  //PL_DB_REGISTER:DB1_RESET_ASSERTED
  localparam DB1_RESET_ASSERTED      = 5;  //PL_DB_REGISTER:DB1_RESET_ASSERTED
  localparam ENABLE_CLOCK_DB0_SIZE = 1;  //PL_DB_REGISTER:ENABLE_CLOCK_DB0
  localparam ENABLE_CLOCK_DB0_MSB  = 8;  //PL_DB_REGISTER:ENABLE_CLOCK_DB0
  localparam ENABLE_CLOCK_DB0      = 8;  //PL_DB_REGISTER:ENABLE_CLOCK_DB0
  localparam ENABLE_CLOCK_DB1_SIZE = 1;  //PL_DB_REGISTER:ENABLE_CLOCK_DB1
  localparam ENABLE_CLOCK_DB1_MSB  = 9;  //PL_DB_REGISTER:ENABLE_CLOCK_DB1
  localparam ENABLE_CLOCK_DB1      = 9;  //PL_DB_REGISTER:ENABLE_CLOCK_DB1
  localparam ENABLE_PLL_REF_CLOCK_SIZE =  1;  //PL_DB_REGISTER:ENABLE_PLL_REF_CLOCK
  localparam ENABLE_PLL_REF_CLOCK_MSB  = 10;  //PL_DB_REGISTER:ENABLE_PLL_REF_CLOCK
  localparam ENABLE_PLL_REF_CLOCK      = 10;  //PL_DB_REGISTER:ENABLE_PLL_REF_CLOCK
  localparam DISABLE_CLOCK_DB0_SIZE =  1;  //PL_DB_REGISTER:DISABLE_CLOCK_DB0
  localparam DISABLE_CLOCK_DB0_MSB  = 12;  //PL_DB_REGISTER:DISABLE_CLOCK_DB0
  localparam DISABLE_CLOCK_DB0      = 12;  //PL_DB_REGISTER:DISABLE_CLOCK_DB0
  localparam DISABLE_CLOCK_DB1_SIZE =  1;  //PL_DB_REGISTER:DISABLE_CLOCK_DB1
  localparam DISABLE_CLOCK_DB1_MSB  = 13;  //PL_DB_REGISTER:DISABLE_CLOCK_DB1
  localparam DISABLE_CLOCK_DB1      = 13;  //PL_DB_REGISTER:DISABLE_CLOCK_DB1
  localparam DISABLE_PLL_REF_CLOCK_SIZE =  1;  //PL_DB_REGISTER:DISABLE_PLL_REF_CLOCK
  localparam DISABLE_PLL_REF_CLOCK_MSB  = 14;  //PL_DB_REGISTER:DISABLE_PLL_REF_CLOCK
  localparam DISABLE_PLL_REF_CLOCK      = 14;  //PL_DB_REGISTER:DISABLE_PLL_REF_CLOCK
  localparam RELEASE_RESET_DB0_SIZE =  1;  //PL_DB_REGISTER:RELEASE_RESET_DB0
  localparam RELEASE_RESET_DB0_MSB  = 16;  //PL_DB_REGISTER:RELEASE_RESET_DB0
  localparam RELEASE_RESET_DB0      = 16;  //PL_DB_REGISTER:RELEASE_RESET_DB0
  localparam RELEASE_RESET_DB1_SIZE =  1;  //PL_DB_REGISTER:RELEASE_RESET_DB1
  localparam RELEASE_RESET_DB1_MSB  = 17;  //PL_DB_REGISTER:RELEASE_RESET_DB1
  localparam RELEASE_RESET_DB1      = 17;  //PL_DB_REGISTER:RELEASE_RESET_DB1
  localparam ASSERT_RESET_DB0_SIZE =  1;  //PL_DB_REGISTER:ASSERT_RESET_DB0
  localparam ASSERT_RESET_DB0_MSB  = 20;  //PL_DB_REGISTER:ASSERT_RESET_DB0
  localparam ASSERT_RESET_DB0      = 20;  //PL_DB_REGISTER:ASSERT_RESET_DB0
  localparam ASSERT_RESET_DB1_SIZE =  1;  //PL_DB_REGISTER:ASSERT_RESET_DB1
  localparam ASSERT_RESET_DB1_MSB  = 21;  //PL_DB_REGISTER:ASSERT_RESET_DB1
  localparam ASSERT_RESET_DB1      = 21;  //PL_DB_REGISTER:ASSERT_RESET_DB1

//===============================================================================
// Register Group PS_CPLD_BASE_REGS
//===============================================================================

  // SIGNATURE_REGISTER Register (from ps_cpld_regs.v)
  localparam SIGNATURE_REGISTER = 'h0; // Register Offset
  localparam SIGNATURE_REGISTER_SIZE = 32;  // register width in bits
  localparam SIGNATURE_REGISTER_MASK = 32'hFFFFFFFF;
  localparam PRODUCT_SIGNATURE_SIZE = 32;  //SIGNATURE_REGISTER:PRODUCT_SIGNATURE
  localparam PRODUCT_SIGNATURE_MSB  = 31;  //SIGNATURE_REGISTER:PRODUCT_SIGNATURE
  localparam PRODUCT_SIGNATURE      =  0;  //SIGNATURE_REGISTER:PRODUCT_SIGNATURE

  // REVISION_REGISTER Register (from ps_cpld_regs.v)
  localparam REVISION_REGISTER = 'h4; // Register Offset
  localparam REVISION_REGISTER_SIZE = 32;  // register width in bits
  localparam REVISION_REGISTER_MASK = 32'hFFFFFFFF;
  localparam REVISION_HH_SIZE = 8;  //REVISION_REGISTER:REVISION_HH
  localparam REVISION_HH_MSB  = 7;  //REVISION_REGISTER:REVISION_HH
  localparam REVISION_HH      = 0;  //REVISION_REGISTER:REVISION_HH
  localparam REVISION_DD_SIZE =  8;  //REVISION_REGISTER:REVISION_DD
  localparam REVISION_DD_MSB  = 15;  //REVISION_REGISTER:REVISION_DD
  localparam REVISION_DD      =  8;  //REVISION_REGISTER:REVISION_DD
  localparam REVISION_MM_SIZE =  8;  //REVISION_REGISTER:REVISION_MM
  localparam REVISION_MM_MSB  = 23;  //REVISION_REGISTER:REVISION_MM
  localparam REVISION_MM      = 16;  //REVISION_REGISTER:REVISION_MM
  localparam REVISION_YY_SIZE =  8;  //REVISION_REGISTER:REVISION_YY
  localparam REVISION_YY_MSB  = 31;  //REVISION_REGISTER:REVISION_YY
  localparam REVISION_YY      = 24;  //REVISION_REGISTER:REVISION_YY

  // OLDEST_COMPATIBLE_REVISION_REGISTER Register (from ps_cpld_regs.v)
  localparam OLDEST_COMPATIBLE_REVISION_REGISTER = 'h8; // Register Offset
  localparam OLDEST_COMPATIBLE_REVISION_REGISTER_SIZE = 32;  // register width in bits
  localparam OLDEST_COMPATIBLE_REVISION_REGISTER_MASK = 32'hFFFFFFFF;
  localparam OLD_REVISION_HH_SIZE = 8;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_HH
  localparam OLD_REVISION_HH_MSB  = 7;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_HH
  localparam OLD_REVISION_HH      = 0;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_HH
  localparam OLD_REVISION_DD_SIZE =  8;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_DD
  localparam OLD_REVISION_DD_MSB  = 15;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_DD
  localparam OLD_REVISION_DD      =  8;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_DD
  localparam OLD_REVISION_MM_SIZE =  8;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_MM
  localparam OLD_REVISION_MM_MSB  = 23;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_MM
  localparam OLD_REVISION_MM      = 16;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_MM
  localparam OLD_REVISION_YY_SIZE =  8;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_YY
  localparam OLD_REVISION_YY_MSB  = 31;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_YY
  localparam OLD_REVISION_YY      = 24;  //OLDEST_COMPATIBLE_REVISION_REGISTER:OLD_REVISION_YY

  // SCRATCH_REGISTER Register (from ps_cpld_regs.v)
  localparam SCRATCH_REGISTER = 'hC; // Register Offset
  localparam SCRATCH_REGISTER_SIZE = 32;  // register width in bits
  localparam SCRATCH_REGISTER_MASK = 32'h0;

  // GIT_HASH_REGISTER Register (from ps_cpld_regs.v)
  localparam GIT_HASH_REGISTER = 'h10; // Register Offset
  localparam GIT_HASH_REGISTER_SIZE = 32;  // register width in bits
  localparam GIT_HASH_REGISTER_MASK = 32'hFFFFFFFF;
  localparam GIT_HASH_SIZE = 28;  //GIT_HASH_REGISTER:GIT_HASH
  localparam GIT_HASH_MSB  = 27;  //GIT_HASH_REGISTER:GIT_HASH
  localparam GIT_HASH      =  0;  //GIT_HASH_REGISTER:GIT_HASH
  localparam GIT_CLEAN_SIZE =  4;  //GIT_HASH_REGISTER:GIT_CLEAN
  localparam GIT_CLEAN_MSB  = 31;  //GIT_HASH_REGISTER:GIT_CLEAN
  localparam GIT_CLEAN      = 28;  //GIT_HASH_REGISTER:GIT_CLEAN
