/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef DELETEUSEREXISTS_H
#define DELETEUSEREXISTS_H

#include <QDialog>
#include "fixlabel.h"

class QHBoxLayout;
class QVBoxLayout;
class QFrame;
class QRadioButton;
class QLabel;
class QPushButton;
class QButtonGroup;

class DeleteUserExists : public QDialog
{
    Q_OBJECT

public:
    explicit DeleteUserExists(QString name, QString nick, QWidget *parent = nullptr);
    ~DeleteUserExists();
public:
    void initUI();
    void setConnect();

public:
    QVBoxLayout * mainVerLayout;
    QHBoxLayout * titleHorLayout;
    QHBoxLayout * noteHorLayout;
    QHBoxLayout * removeButKeepFilesHorLayout;
    QHBoxLayout * removeWholeHorLayout;
    QHBoxLayout * bottomBtnsHorLayout;

    QFrame * removeButKeepFilesFrame;
    QFrame * removeWholeFrame;

    QButtonGroup * removeBtnGroup;

    QRadioButton * removeButKeepFilesRadioBtn;
    QRadioButton * removeWholeRadioBtn;

    QLabel *noteLabel;
    FixLabel *removeButKeepFilesLabel;
    FixLabel *removeWholeLabel;

    QPushButton * cancelBtn;
    QPushButton * confirmBtn;

protected:
    bool eventFilter(QObject *watched, QEvent *event);

private:
    QString _name;
    QString _nick;

signals:
    void confirmChanged(bool removeFiles);
};

#endif // DELETEUSEREXISTS_H
