﻿/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2019 Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */
#ifndef UKMEDIASOUNDEFFECTSWIDGET_H
#define UKMEDIASOUNDEFFECTSWIDGET_H

#include <QWidget>
#include <QComboBox>
#include <QLabel>
#include <QMessageBox>
#include <QHBoxLayout>
#include <QStyledItemDelegate>
#include "ukui_custom_style.h"
#include "switchbutton.h"
#include "kswitchbutton.h"

using namespace kdk;


class UkuiMessageBox : public QMessageBox
{
public:
    explicit UkuiMessageBox();
};

class UkmediaSoundEffectsWidget : public QWidget
{
    Q_OBJECT
public:
    explicit UkmediaSoundEffectsWidget(QWidget *parent = nullptr);
    ~UkmediaSoundEffectsWidget();
    friend class UkmediaMainWidget;
Q_SIGNALS:

public Q_SLOTS:

private:
    QFrame *myLine();
    QFrame *m_pSystemSoundWidget;//存放注销、唤醒、开机、关机提示音的窗口
    QFrame *m_pLagoutWidget;//注销提示音窗口
    QFrame *m_pWakeupMusicWidget;//唤醒音乐窗口
    QFrame *m_pStartupMusicWidget;//设置开机音乐窗口
    QFrame *m_pPoweroffMusicWidget;//关机提示音

    QFrame *m_pAlertSoundFrame;//存放注销、唤醒、开机、关机提示音的窗口
    QFrame *m_pAlertSoundSwitchWidget;//提示音开关窗口
    QFrame *m_pThemeWidget;//提示音下的系统音效主题
    QFrame *line1;

    QString qss;
    QStyledItemDelegate *itemDelegate;
    TitleLabel *m_pSoundEffectLabel;
    QLabel *m_pSoundThemeLabel;
    QLabel *m_pLagoutLabel;
    QLabel *m_pAlertSoundSwitchLabel;
    QLabel *m_pWakeupMusicLabel;
    QLabel *m_pPoweroffMusicLabel;
    QLabel *m_pStartupMusicLabel;

    QComboBox *m_pSoundThemeCombobox;
    QVBoxLayout *m_pSoundLayout;

    KSwitchButton *m_pStartupButton;
    KSwitchButton *m_pPoweroffButton;
    KSwitchButton *m_pLogoutButton;
    KSwitchButton *m_pAlertSoundSwitchButton;
    KSwitchButton *m_pWakeupMusicButton;


//    2209 remove volumechange、alertsound widget，Follow the theme to switch with one click

//    QLabel *m_pShutdownlabel;
//    QLabel *m_pAlertSoundLabel;
//    QLabel *m_pAlertVolumeLabel;
//    QLabel *m_pVolumeChangeLabel;
//    QComboBox *m_pAlertSoundCombobox;
//    QComboBox *m_pLagoutCombobox;
//    QComboBox *m_pVolumeChangeCombobox;
//    QFrame *m_pAlertSoundWidget;//提示音下的通知提示
//    QFrame *m_pVolumeChangeWidget;//提示音下的音量调节
//    QFrame *line2;
//    QFrame *line3;


//    UkmediaVolumeSlider *m_pAlertSlider;
//    UkuiButtonDrawSvg *m_pAlertIconBtn;
};

#endif // UKMEDIASOUNDEFFECTSWIDGET_H
