/*
 * unity-npapi-plugin-pp-funcs.c
 * Copyright (C) Canonical LTD 2012
 * 
 * Author: Alexandre Abreu <alexandre.abreu@canonical.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>

#include <unity-webapps-service.h>
#include <unity-webapps-context.h>

#include "unity-npapi-plugin.h"

#include "npapi-headers/headers/npapi.h"
#include "npapi-headers/headers/npfunctions.h"

#include "unity-webapps-scriptable-object.h"


// TODO figure out what to do w/ this
// This is a Gecko type
typedef enum { PR_FALSE = 0, PR_TRUE = 1 } PRBool;

static unity_npapi_plugin_t * plugin_allocate ();
static void plugin_delete (unity_npapi_plugin_t *);


/**
 * new plugin instance being created
 */

NPError NPP_New (NPMIMEType pluginType,
		 NPP npp,
		 uint16_t mode,
		 int16_t argc,
		 char* argn[],
		 char* argv[],
		 NPSavedData* saved)
{
  if (NULL == npp)
    {
      return NPERR_INVALID_INSTANCE_ERROR;
    }
	
  NPError rv = NPERR_NO_ERROR;
	
  {
    // TODO avoid individual steps
    unity_npapi_plugin_t
      * pPlugin = plugin_allocate ();
      	
    pPlugin->npp = npp;
        
    npp->pdata = pPlugin;
  }
	
  return rv;
}


// Deletes a specific instance of a plug-in.

NPError NPP_Destroy (NPP instance, NPSavedData **save)
{
  NPError rv = NPERR_INVALID_INSTANCE_ERROR;
  if (NULL == instance || NULL == instance->pdata)
    {
      return rv;
    }

  plugin_delete (instance->pdata);

  return NPERR_NO_ERROR;
}


NPError NPP_SetWindow(NPP instance, NPWindow *window)
{
  // not really interested
	
  NPError rv = NPERR_NO_ERROR;
  return rv;
}

NPError NPP_NewStream(NPP        instance, 
                      NPMIMEType type,
                      NPStream*  stream,
                      NPBool     seekable,
                      uint16_t*    stype)
{
  // not really interested
    
  NPError rv = NPERR_NO_ERROR;
  return rv;
}

NPError NPP_DestroyStream (NPP       instance, 
                           NPStream* stream, 
                           NPReason  reason)
{
  // not really interested
    
  NPError rv = NPERR_NO_ERROR;
  return rv;
}

void NPP_StreamAsFile (NPP         instance,
		       NPStream*   stream,
		       const char* fname)
{
  // not really interested
    
}

int32_t NPP_WriteReady (NPP instance, NPStream* stream)
{
  // not really interested
    
  return 0;
}

int32_t NPP_Write (NPP instance, 
		   NPStream* stream,
		   int32_t offset, 
		   int32_t len, 
		   void* buf)

{
  // not really interested
    
  return 0;
}

void NPP_Print (NPP instance, NPPrint* PrintInfo)
{
  // not really interested
}

int16_t NPP_HandleEvent(NPP instance, void* event)
{
  // not really interested
  return 0;
}

void NPP_URLNotify (NPP         instance, 
		    const char* url,
		    NPReason    reason, 
		    void*       notifyData)
{
  // not really interested
}


NPError NPP_GetValue (NPP instance, 
		      NPPVariable variable, 
		      void *value)
{
  NPError
    rv = NPERR_INVALID_INSTANCE_ERROR;
  if (NULL == instance || NULL == value)
    {
      return rv;
    }

  rv = NPERR_NO_ERROR;

  // TODO: some of it kind of redundant w/ what's in the NP_GetValue func ... check which one matters

  switch(variable)
    {
    case NPPVpluginNameString:
      {
	*((char **)value) = "Name";
      }
      break;

    case NPPVpluginDescriptionString:    // Plugin description
      {
	*((char **)value) = "Description";
      }
      break;

    case NPPVpluginScriptableNPObject:// Scriptable plugin interface (for accessing from javascript)
      {
	NPObject * object = unity_webapps_npapi_create_unity_webapps_object (instance);
	
	// TODO what about NULL?
	if (NULL != object)
	  {
	    //	    NPN_RetainObject (object);
	  }
	
	*(NPObject **)value = object;
      }
      break;

    case NPPVpluginWindowBool:
      {
	// default
	// TODO does it matter?
	*((PRBool *) value) = true;
      }
      break;

    case NPPVpluginNeedsXEmbed:
      {
	// Chromium sort of require this, we must  handle this case.
	NPBool support = false;
  	 	    
	NPN_GetValue (instance, NPNVSupportsXEmbedBool, &support);

	*((NPBool *) value) = support;
  			
	rv = NPERR_NO_ERROR;
      }
      break;

    default:
      rv = NPERR_NO_ERROR;
    }

  return rv;
}


NPError NPP_SetValue (NPP instance,
		      NPNVariable variable,
		      void *value)
{
  NPError
    rv = NPERR_INVALID_INSTANCE_ERROR;
    
  if (NULL == instance || NULL == value)
    {
      return rv;
    }

  rv = NPERR_NO_ERROR;
	
  return rv;
}

static unity_npapi_plugin_t * plugin_allocate ()
{
  unity_npapi_plugin_t * pPlugin =
    g_malloc0 (sizeof (unity_npapi_plugin_t));
  if (pPlugin)
    {
      pPlugin->retained_objects = g_hash_table_new (g_direct_hash, g_direct_equal);
    }
  return pPlugin;
}

static void plugin_delete (unity_npapi_plugin_t * pPlugin)
{
  if (pPlugin)
    {
      if (pPlugin->retained_objects)
        {
          unity_npapi_free_all_retained_objects (pPlugin);

          g_hash_table_destroy (pPlugin->retained_objects);
        }
      g_free (pPlugin);
    }
}



