'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbSAScreen __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbSAScreen \- Returns the screenXXX field of act converted to a signed int
.SH SYNOPSIS
.HP
.B int XkbSAScreen 
.BI "(\^XkbSwitchScreenAction " "act" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- act
action from which to extract screen
.SH DESCRIPTION
.LP
Actions associated with the XkbSwitchScreen action structure change the active 
screen on a multiscreen display.

The 
.I type 
field of the XkbSwitchScreenAction structure should always be 
XkbSA_SwitchScreen.

The 
.I flags 
field is composed of the bitwise inclusive OR of the masks shown in Table 1.

.TS
c s
l l
l lw(4i).
Table 1 Switch Screen Action Flags
_
Flag	Meaning
_
XkbSA_SwitchAbsolute	T{
If set, the screenXXX field represents the index of the new screen. Otherwise, 
it represents an offset from the current screen to the new screen.
T}
XkbSA_SwitchApplication	T{
If not set, the action should switch to another screen on the same server. 
Otherwise, it should switch to another X server or application that shares the 
same physical display.
T}
.TE

The 
.I screenXXX 
field is a signed character value that represents either the relative or 
absolute screen index, depending on the state of the XkbSA_SwitchAbsolute bit in 
the 
.I flags 
field. Xkb provides the following macros to convert between the integer and 
signed character value for screen numbers in XkbSwitchScreenAction structures.

.I XkbSAScreen 
macro returns the 
.I screenXXX 
field of 
.I act 
converted to a signed int. 
.SH STRUCTURES
.LP
.nf

    typedef struct _XkbSwitchScreenAction {
        unsigned char    type;        /\(** XkbSA_SwitchScreen */
        unsigned char    flags;       /\(** controls screen switching */
        char             screenXXX;   /\(** screen number or delta */
    } XkbSwitchScreenAction;

.fi

.SH NOTES
.LP
The XkbSwitchScreen action is optional. Servers are free to ignore the action or 
any of its 
flags if they do not support the requested behavior. If the action is ignored, 
it behaves like XkbSA_NoAction. Otherwise, key press and key release events do 
not generate an event. 
